unit card;

interface

var
    DriverIsLoaded: Boolean = False;
    Port:Integer=$284;
    //alternate is $384

const
     PLUGINS_PATH= 'Plugins';
     PLUGIN_NAME= 'sf16fmi';
     ConfigurationMessage= 'You can set port of the ' +PLUGIN_NAME + ' by editing (or creating) '
                           +#10#13+'the plugins.ini file in Radiator''s plugins directory.'
                           +#10#13+'Port settings are stored in Port entry of the ['
                           +PLUGIN_NAME+'] section.'
                           +#10#13+'Example: Port=$384'
                           +#10#13+'Possible values are: $284 (default), $384 (alternate).'
                           +#10#13+'Then it is necessary to re-load the plugin.';



{Module supports following functions}
     FM_TUNE=                  1 shl 0;  //1 - supports set frequency
     FM_TUNEMUTED=             1 shl 1;  //2 - supports set frequency "silently"
                                         //Output is muted, but frequency is set.
					 // Then just unmute  to hear it.
     FM_MUTEUNMUTE=            1 shl 2;  //4 - supports muting/unmuting
     FM_GETVOLUME=             1 shl 3;  //8 - supports GetVolume
     FM_SETVOLUMEBYVALUE=      1 shl 4;  //16 - set volume "digitally"  by setting a value
     FM_SETVOLUMEUPDOWN=       1 shl 5;  //32 - supports up and  down by discrete steps
     FM_BASSTREBLE=            1 shl 6;  //64 - supports bass & treble
     FM_ISSTEREO=              1 shl 7;  //128 - supports stereo identification
     FM_SETSTEREO=             1 shl 8;  //256 - also called forced stereo or mono
     FM_GETSIGNAL=             1 shl 9;  //512 - station is/is not tuned to signal
     FM_AMRANGE=               1 shl 10; //1024 - supports AM range
     FM_RDS=                   1 shl 11; //2048 - supports RDS - not prepared in any way yet ;-)
     FM_SCANSTATION=           1 shl 12; //4096 - support scanning - parameters are
                                         //direction (up to high range or down to low range
                                         //and current frequency to search from
                                         //it returns new frequency
     FM_CONFIGURATIONDIALOG=   1 shl 16; //65536 - launches configuration dialog

{Required in all plugins}
     function GetModuleName: PChar; stdcall;    //must not be empty for Radiator to recognize the plugin
     function GetModuleInfo: Cardinal; stdcall; // ORed "module supports" constants
                                                // eg.  FM_TUNE or FM_MUTEUNMUTE
		        			// which is the same as FM_TUNE + FM_MUTEUNMUTE
			        		// result is 1 + 4 = 5
     function HWInit: Boolean; stdcall; 	//initializes hardware
     function HWDeInit: Boolean; stdcall;	//deinitializes hardware

{Optional}
     function GetModuleComment: PChar; stdcall;         //description, copyright etc.
     procedure TuneFreq (Freq: LongInt); stdcall;       //matches FM_TUNE;
							//frequency in kHz (88.2 MHz -> 88200 kHz)
     procedure TuneFreqMuted (Freq: LongInt); stdcall;	//matches FM_TUNEMUTED
							//frequency in kHz (88.2 MHz -> 88200 kHz)
     procedure SetMute (Mute: Boolean); stdcall;	//matches FM_MUTEUNMUTE
     function ScanStation (DirectionUp:Boolean; FreqToSearchFrom: LongInt): LongInt; stdcall; //matches FM_SCANSTATION
                                                        //parameters are
                                                        //direction (up to high range or down to low range
                                                        //and current frequency to search from
                                                        //it returns new frequency
     function GetVolume: Word; stdcall;                 //matches GETVOLUME
     procedure SetVolume (Left,Right: Word); stdcall;	//matches FM_SETVOLUMEBYVALUE
     procedure VolumeUpDown(Step: Integer); stdcall;	//matches FM_SETVOLUMEBYVALUE
     procedure SetBass(Bass: Word); stdcall;		//matches FM_BASSTREBLE
     function GetBass: Word; stdcall;			//matches FM_BASSTREBLE
     procedure SetTreble(Treble: Word); stdcall;	//matches FM_BASSTREBLE
     function GetTreble: Word; stdcall;			//matches FM_BASSTREBLE
     function IsStereo: Boolean; stdcall;		//matches FM_ISSTEREO
     procedure SetStereo (Stereo: Boolean); stdcall;    //matches FM_SETSTEREO
     function GetSignal: Word; stdcall;			//matches FM_GETSIGNAL
     procedure ConfigurationDialog; stdcall;		//matches FM_CONFIGURATIONDIALOG

{Direct access to port performed by dlportio.dll shipped and installed with Radiator
 DO NOT USE YOUR OWN DRIVERS NOR DIRECT ASM PORT DIRECTIVES -
 IT WOULD BE UNNECESSARY AND REDUNDANT,
 port access by asm directives does not work on NT based systems.

 Default path where the plugins are installed is RADIATOR_PATH+PLUGINS_PATH
 dlportio.sys is always in RADIATOR_PATH directory, where it can be accessed.}

     function GetPortByte(Address : Word) : Byte;
     procedure SetPortByte(Address : Word; Data : Byte);
     function GetPortWord(Address : Word) : Word;
     procedure SetPortWord(Address : Word; Data : Word);
     function GetPortDWord(Address : Word) : Longword;
     procedure SetPortDWord(Address : Word; Data : Longword);
     function OpenDriver: Boolean;
     procedure CloseDriver;
{*** End of dlportio.dll functions and procedures declaration ***}

{IniFiles}
function ReadString(const Section, Ident, Default: string): string;
function GetParamStr(P: PChar; var Param: string): PChar;
function ParamStr(Index: Integer): string;

implementation
uses Windows, SysUtils;

{*** dlportio.dll types ***}
type
   TDlPortReadPortUchar = function(Port : Word) : Byte; stdcall;
   TDlPortReadPortUshort = function(Port : Word) : Word; stdcall;
   TDlPortReadPortUlong =  function(Port : Word) : Longword; stdcall;
   TDlPortWritePortUchar = procedure(Port : Word; Value : Byte); stdcall;
   TDlPortWritePortUshort = procedure(Port : Word; Value : Word); stdcall;
   TDlPortWritePortUlong = procedure(Port : Word; Value : Longword); stdcall;
{*** end of dlportio.dll types ***}

{*** dlportio.dll constants ***}
const
     DLPORTIONAME='dlportio.dll';
{*** dlportio.dll constants ***}

{*** dlportio.dll variables ***}
var
    DLLHandle: LongWord;

//dlportio.dll pointers
    DlReadByte : TDlPortReadPortUchar;
    DlReadWord : TDlPortReadPortUshort;
    DlReadDWord : TDlPortReadPortUlong;

    DlWriteByte : TDlPortWritePortUchar;
    DlWriteWord : TDlPortWritePortUshort;
    DlWriteDWord : TDlPortWritePortUlong;
{*** dlportio.dll variables ***}

function GetModuleName: PChar;
begin
 Result:='SoundForte SF16-FMI';
end;

function GetModuleInfo: Cardinal;
begin
 Result:=
 FM_TUNE + FM_TUNEMUTED + FM_MUTEUNMUTE + FM_GETSIGNAL + FM_CONFIGURATIONDIALOG;
end;

function HWInit:Boolean;
begin
Result:= OpenDriver;
end;

function HWDeInit:Boolean;
begin
CloseDriver;
Result:= True;
end;

{Optional}
function GetModuleComment: PChar;
begin
 Result:= 'Freeware. Made for Radiator. Copyright  2001 Miroslav Flesko. http://flesko.cz';
end;

procedure TuneFreq (Freq: LongInt);
var Bits: Cardinal;
function FMIWriteBits (NumberOfBits, Data: Integer) : Boolean;
var I: Integer;
begin
for I:= NumberOfBits downto 1 do begin
 if (Data and $1)=1 then begin
                 SetPortByte(Port,$5);
                 SetPortByte(Port,$7);
                 end
                 else begin
                 SetPortByte(Port,$1);
                 SetPortByte(Port,$3)
                 end;
 Data:=(Data shr 1);
end;
Result:=True;
end;

begin
Bits:=Round ((Freq/1000*20) + 214);
  try
  FMIWriteBits (16, Bits);
  FMIWriteBits (8, $C0);
  SetMute (False);
  except;
  end;
end;

procedure TuneFreqMuted (Freq: LongInt);
begin
SetMute(True);
TuneFreq(Freq);
SetMute(True);
end;

procedure SetMute (Mute: Boolean);
begin
  try
  if Mute then SetPortByte(Port,0) else SetPortByte(Port,$8);
  except;
  end;
end;

function ScanStation (DirectionUp:Boolean; FreqToSearchFrom: LongInt): LongInt;
begin
//Result:=FreqToSearchFrom;
end;

function GetVolume: Word;
begin
// Result:= 0;
end;

procedure SetVolume (Left,Right: Word);
begin
//
end;

procedure VolumeUpDown(Step: Integer);
begin
//
end;

procedure SetBass(Bass: Word);
begin
//
end;

function GetBass: Word;
begin
// Result:= 0;
end;

procedure SetTreble(Treble: Word);
begin
//
end;

function GetTreble: Word;
begin
// Result:= 0;
end;


function IsStereo: Boolean;
begin
// Result:= False;
end;


procedure SetStereo (Stereo: Boolean);
begin
//
end;

function GetSignal: Word;
begin
  SetPortByte(Port,$10);
  Sleep (270);
  if GetPortByte(Port+1)<254 then Result:=0 else Result:=$9999; //65535
  if Result <>0 then SetMute (False);
end;

procedure ConfigurationDialog;
begin
MessageBox(GetActiveWindow,PChar(ConfigurationMessage),'Configuration dialog',MB_OK);
end;



{*** Port access using dlportio.dll ***}
function GetPortByte(Address : Word) : Byte;
begin
   Result := DlReadByte(Address);
end;

procedure SetPortByte(Address : Word; Data : Byte);
begin
   DlWriteByte(Address, Data);
end;

function GetPortWord(Address : Word) : Word;
begin
   Result := DlReadWord(Address);
end;

procedure SetPortWord(Address : Word; Data : Word);
begin
   DlWriteWord(Address, Data);
end;

function GetPortDWord(Address : Word) : Longword;
begin
   Result := DlReadDWord(Address);
end;

procedure SetPortDWord(Address : Word; Data : Longword);
begin
   DlWriteDWord(Address, Data);
end;

function OpenDriver: Boolean;
var
   LibraryFileName : AnsiString;
begin
    try
    Port:=StrToInt(ReadString(PLUGIN_NAME,'Port','$284'));
    except Port:=$284;
    end;
    if DriverIsLoaded then begin
                      Result:=True;
                      Exit;
                      end;
   LibraryFileName:= ExtractFileDir(ParamStr(0))+'\'+DLPORTIONAME;

   DLLHandle:=LoadLibrary(PChar(LibraryFileName));
   if (DLLHandle<>0) then
   begin
      @DlReadByte:=GetProcAddress(DLLHandle,'DlPortReadPortUchar');
      @DlReadWord:=GetProcAddress(DLLHandle,'DlPortReadPortUshort');
      @DlReadDWord:=GetProcAddress(DLLHandle,'DlPortReadPortUlong');

      @DlWriteByte:=GetProcAddress(DLLHandle,'DlPortWritePortUchar');
      @DlWriteWord:=GetProcAddress(DLLHandle,'DlPortWritePortUshort');
      @DlWriteDWord:=GetProcAddress(DLLHandle,'DlPortWritePortUlong');

      // Make sure all functions are there
      if ((@DlReadByte<>nil) and (@DlReadWord<>nil) and
          (@DlReadDWord<>nil) and (@DlWriteByte<>nil) and
          (@DlWriteWord<>nil) and (@DlWriteDWord<>nil)) then
         DriverIsLoaded:= True;// Success
   end
   else begin
      // Free the library
      if (DLLHandle<>0) then
      begin
         FreeLibrary(DLLHandle);
         DLLHandle:=0;
      end;
   end;
   Result:=DriverIsLoaded;
end;

procedure CloseDriver;
begin
   if (not DriverIsLoaded) then Exit;
      if (DLLHandle<>0) then
      begin
         FreeLibrary(DLLHandle);
         DLLHandle:=0;
      end;
   DriverIsLoaded:= False;
end;
{*** End of port access using dlportio.dll ***}

function ReadString(const Section, Ident, Default: string): string;
var
  Buffer: array[0..2047] of Char;
begin
  SetString(Result, Buffer, GetPrivateProfileString(PChar(Section),
    PChar(Ident), PChar(Default), Buffer, SizeOf(Buffer),
    PChar(ExtractFileDir(ParamStr(0))+'\'+PLUGINS_PATH+'\plugins.ini')));
end;

function GetParamStr(P: PChar; var Param: string): PChar;
var
  Len: Integer;
  Buffer: array[0..4095] of Char;
begin
  while True do
  begin
    while (P[0] <> #0) and (P[0] <= ' ') do Inc(P);
    if (P[0] = '"') and (P[1] = '"') then Inc(P, 2) else Break;
  end;
  Len := 0;
  while (P[0] > ' ') and (Len < SizeOf(Buffer)) do
    if P[0] = '"' then
    begin
      Inc(P);
      while (P[0] <> #0) and (P[0] <> '"') do
      begin
        Buffer[Len] := P[0];
        Inc(Len);
        Inc(P);
      end;
      if P[0] <> #0 then Inc(P);
    end else
    begin
      Buffer[Len] := P[0];
      Inc(Len);
      Inc(P);
    end;
  SetString(Param, Buffer, Len);
  Result := P;
end;


function ParamStr(Index: Integer): string;
var
  P: PChar;
  Buffer: array[0..260] of Char;
begin
  if Index = 0 then
    SetString(Result, Buffer, GetModuleFileName(0, Buffer, SizeOf(Buffer)))
  else
  begin
    P := GetCommandLine;
    while True do
    begin
      P := GetParamStr(P, Result);
      if (Index = 0) or (Result = '') then Break;
      Dec(Index);
    end;
  end;
end;

end.


